/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.mapping.tile;

import com.badlogic.gdx.math.GridPoint2;
import com.badlogic.gdx.math.Vector2;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import technology.rocketjump.undermount.assets.model.FloorType;
import technology.rocketjump.undermount.assets.model.GameMaterial;
import technology.rocketjump.undermount.assets.model.GameMaterialType;
import technology.rocketjump.undermount.assets.model.WallType;
import technology.rocketjump.undermount.doors.Doorway;
import technology.rocketjump.undermount.entities.model.Entity;
import technology.rocketjump.undermount.entities.model.EntityType;
import technology.rocketjump.undermount.entities.model.physical.EntityAttributes;
import technology.rocketjump.undermount.entities.model.physical.furniture.FurnitureEntityAttributes;
import technology.rocketjump.undermount.entities.model.physical.item.ItemEntityAttributes;
import technology.rocketjump.undermount.entities.model.physical.plant.PlantEntityAttributes;
import technology.rocketjump.undermount.entities.model.physical.plant.PlantSpeciesType;
import technology.rocketjump.undermount.mapping.tile.MapVertex;
import technology.rocketjump.undermount.mapping.tile.TileNeighbours;
import technology.rocketjump.undermount.mapping.tile.TileRoof;
import technology.rocketjump.undermount.mapping.tile.designation.TileDesignation;
import technology.rocketjump.undermount.mapping.tile.floor.CellFloor;
import technology.rocketjump.undermount.mapping.tile.floor.FloorOverlap;
import technology.rocketjump.undermount.mapping.tile.floor.OverlapLayout;
import technology.rocketjump.undermount.mapping.tile.layout.WallLayout;
import technology.rocketjump.undermount.mapping.tile.wall.Wall;
import technology.rocketjump.undermount.rooms.RoomTile;
import technology.rocketjump.undermount.rooms.constructions.Construction;

public class MapTile {
    private final long seed;
    private Map<Long, Entity> entities = new HashMap<Long, Entity>();
    private TileRoof roof = TileRoof.UNDERGROUND;
    private Wall wall = null;
    private Doorway doorway = null;
    private final CellFloor floor;
    private final GridPoint2 tilePosition;
    private TileDesignation designation = null;
    private RoomTile roomTile = null;
    private Construction construction = null;

    public MapTile(long seed, int tileX, int tileY, FloorType floorType, GameMaterial floorMaterial) {
        this.seed = seed;
        this.tilePosition = new GridPoint2(tileX, tileY);
        this.floor = new CellFloor(floorType, floorMaterial);
    }

    public void update(TileNeighbours neighbours, MapVertex[] vertexNeighboursOfCell) {
        if (this.hasWall()) {
            WallLayout newLayout = new WallLayout(neighbours);
            this.wall.setTrueLayout(newLayout);
        } else if (this.hasFloor()) {
            TreeSet<FloorOverlap> overlaps = new TreeSet<FloorOverlap>(new FloorType.FloorDefinitionComparator());
            for (MapTile neighbour : neighbours.values()) {
                if (!neighbour.hasFloor() || neighbour.getFloor().getFloorType().getLayer() <= this.floor.getFloorType().getLayer()) continue;
                OverlapLayout layout = OverlapLayout.fromNeighbours(neighbours, neighbour.getFloor().getFloorType());
                overlaps.add(new FloorOverlap(layout, neighbour.getFloor().getFloorType(), neighbour.getFloor().getMaterial(), vertexNeighboursOfCell));
            }
            this.floor.getOverlaps().clear();
            for (FloorOverlap overlap : overlaps) {
                this.floor.getOverlaps().add(overlap);
            }
            if (this.floor.getFloorType().isUseMaterialColor()) {
                float floorMaterialColor;
                this.floor.vertexColors[0] = floorMaterialColor = this.floor.getMaterial().getColor().toFloatBits();
                this.floor.vertexColors[1] = floorMaterialColor;
                this.floor.vertexColors[2] = floorMaterialColor;
                this.floor.vertexColors[3] = floorMaterialColor;
            } else {
                this.floor.vertexColors[0] = this.floor.getFloorType().getColorForHeightValue(vertexNeighboursOfCell[0].getHeightmapValue()).toFloatBits();
                this.floor.vertexColors[1] = this.floor.getFloorType().getColorForHeightValue(vertexNeighboursOfCell[1].getHeightmapValue()).toFloatBits();
                this.floor.vertexColors[2] = this.floor.getFloorType().getColorForHeightValue(vertexNeighboursOfCell[2].getHeightmapValue()).toFloatBits();
                this.floor.vertexColors[3] = this.floor.getFloorType().getColorForHeightValue(vertexNeighboursOfCell[3].getHeightmapValue()).toFloatBits();
            }
        }
    }

    public Collection<Entity> getEntities() {
        return this.entities.values();
    }

    public TileRoof getRoof() {
        return this.roof;
    }

    public void setRoof(TileRoof roof) {
        this.roof = roof;
    }

    public boolean hasWall() {
        return this.wall != null;
    }

    public boolean isNavigable() {
        return this.isNavigable(null);
    }

    public boolean isNavigable(MapTile startingPoint) {
        if (!this.hasWall() && !this.hasTree()) {
            for (Entity entity : this.getEntities()) {
                EntityAttributes attributes;
                if (entity.getType().equals((Object)EntityType.FURNITURE)) {
                    attributes = (FurnitureEntityAttributes)entity.getPhysicalEntityComponent().getAttributes();
                    if (!((FurnitureEntityAttributes)attributes).getFurnitureType().getFurnitureCategory().isBlocksMovement()) continue;
                    if (startingPoint != null) {
                        boolean startingPointHasSameEntity;
                        boolean bl = startingPointHasSameEntity = startingPoint.getEntity(entity.getId()) != null;
                        if (startingPointHasSameEntity) continue;
                        return false;
                    }
                    return false;
                }
                if (!entity.getType().equals((Object)EntityType.ITEM) || !((ItemEntityAttributes)(attributes = (ItemEntityAttributes)entity.getPhysicalEntityComponent().getAttributes())).getItemType().blocksMovement()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean hasFloor() {
        return this.wall == null;
    }

    public Wall getWall() {
        return this.wall;
    }

    public void setWall(Wall wall, TileRoof roof) {
        this.wall = wall;
        this.setRoof(roof);
    }

    public void addWall(TileNeighbours neighbours, GameMaterial material, WallType wallType) {
        this.wall = new Wall(new WallLayout(neighbours), wallType, material);
    }

    public long getSeed() {
        return this.seed;
    }

    public CellFloor getFloor() {
        return this.floor;
    }

    public int getTileX() {
        return this.tilePosition.x;
    }

    public int getTileY() {
        return this.tilePosition.y;
    }

    public Vector2 getWorldPositionOfCenter() {
        return new Vector2(0.5f + (float)this.tilePosition.x, 0.5f + (float)this.tilePosition.y);
    }

    public Entity removeEntity(long entityId) {
        return this.entities.remove(entityId);
    }

    public void addEntity(Entity entity) {
        this.entities.put(entity.getId(), entity);
    }

    public boolean hasTree() {
        for (Entity entity : this.entities.values()) {
            PlantEntityAttributes attributes;
            if (!entity.getType().equals((Object)EntityType.PLANT) || !(attributes = (PlantEntityAttributes)entity.getPhysicalEntityComponent().getAttributes()).getSpecies().getPlantType().equals((Object)PlantSpeciesType.TREE)) continue;
            return true;
        }
        return false;
    }

    public boolean hasShrub() {
        for (Entity entity : this.entities.values()) {
            PlantEntityAttributes attributes;
            if (!entity.getType().equals((Object)EntityType.PLANT) || !(attributes = (PlantEntityAttributes)entity.getPhysicalEntityComponent().getAttributes()).getSpecies().getPlantType().equals((Object)PlantSpeciesType.SHRUB)) continue;
            return true;
        }
        return false;
    }

    public TileDesignation getDesignation() {
        return this.designation;
    }

    public void setDesignation(TileDesignation designation) {
        this.designation = designation;
    }

    public boolean hasRoom() {
        return this.roomTile != null;
    }

    public RoomTile getRoomTile() {
        return this.roomTile;
    }

    public void setRoomTile(RoomTile roomTile) {
        this.roomTile = roomTile;
    }

    public GridPoint2 getTilePosition() {
        return this.tilePosition;
    }

    public boolean hasItem() {
        for (Entity entity : this.entities.values()) {
            if (!entity.getType().equals((Object)EntityType.ITEM)) continue;
            return true;
        }
        return false;
    }

    public Entity getItemMatching(ItemEntityAttributes attributesToMatch) {
        for (Entity entity : this.getEntities()) {
            ItemEntityAttributes attributes;
            if (!entity.getType().equals((Object)EntityType.ITEM) || !(attributes = (ItemEntityAttributes)entity.getPhysicalEntityComponent().getAttributes()).getItemType().equals(attributesToMatch.getItemType())) continue;
            for (GameMaterialType gameMaterialType : attributes.getItemType().getMaterialTypes()) {
                if (!attributes.getMaterial(gameMaterialType).equals(attributesToMatch.getMaterial(gameMaterialType))) continue;
                return entity;
            }
        }
        return null;
    }

    public boolean isEmpty() {
        if (this.hasWall() || this.hasDoorway() || this.hasConstruction()) {
            return false;
        }
        for (Entity entity : this.entities.values()) {
            if (!entity.getType().equals((Object)EntityType.ITEM) && !entity.getType().equals((Object)EntityType.PLANT) && !entity.getType().equals((Object)EntityType.FURNITURE)) continue;
            return false;
        }
        return true;
    }

    public boolean isEmptyExceptEntities() {
        return !this.hasWall() && !this.hasDoorway() && !this.hasConstruction();
    }

    public Entity getEntity(long entityId) {
        return this.entities.get(entityId);
    }

    public Entity getFirstItem() {
        for (Entity entity : this.entities.values()) {
            if (!entity.getType().equals((Object)EntityType.ITEM)) continue;
            return entity;
        }
        return null;
    }

    public boolean hasDoorway() {
        return this.doorway != null;
    }

    public Doorway getDoorway() {
        return this.doorway;
    }

    public void setDoorway(Doorway doorway) {
        this.doorway = doorway;
    }

    public boolean hasConstruction() {
        return this.construction != null;
    }

    public Construction getConstruction() {
        return this.construction;
    }

    public void setConstruction(Construction construction) {
        this.construction = construction;
    }
}

